# Flip‑Count Simulator

This mini‑repository computes per‑link tick‑flip counts for a 4×4 periodic lattice
using the core tick‑flip operator algebra.  It is designed to be used as part of
the Volume 4 discrete gauge simulation.

## Usage

1. Adjust parameters in `config.yaml` such as the context depth `N`, number of
   steps per link, and random seed.
2. Run the generator script:

   ```bash
   python scripts/generate_flip_counts.py
   ```

The script loads or builds a default 4×4 lattice, runs the tick‑flip operators
on each link, counts the number of changes at a link‑dependent index in the
distribution, and writes a NumPy array of 32 flip counts to
`data/flip_counts.npy`.  This file is then consumed by the Wilson‑loop pipeline.

### Integration with the Volume 4 pipeline

This simulator is intended to be used in concert with the Volume 4 Wilson–loop
pipeline.  After running `scripts/generate_flip_counts.py` the resulting
`flip_counts.npy` file can be consumed by the pipeline by setting the
`flip_counts_path` parameter in `vol4-discrete-gauge-wilson-loop/config.yaml`:

```yaml
flip_counts_path: ../vol4-flip-count-simulator/data/flip_counts.npy
```

When run from within the integrated workspace (see the root‑level
`bootstrap_and_run.sh` script) the simulator will write its outputs into
``vol4-flip-count-simulator/data`` and the pipeline will locate them using the
relative path above.  The wrapper script does not require conda; it simply
invokes ``python scripts/generate_flip_counts.py`` followed by the
Wilson‑loop simulation.  Ensure that the three repositories
(``ar-operator-core``, ``vol4-flip-count-simulator`` and
``vol4-discrete-gauge-wilson-loop``) live side‑by‑side in the same
directory.  You do **not** need to install ``ar-operator-core`` into your
Python environment—the script temporarily adds it to ``sys.path`` when run.